/**
 * External dependencies
 */
import Swal, { SweetAlertOptions } from 'sweetalert2';

const defaultOptions: SweetAlertOptions = {
    timer: 2000,
    showConfirmButton: false,
};

export const SwalError = (options: SweetAlertOptions = {}) => {
    const basic: SweetAlertOptions = {
        iconHtml: '<i class="tio-error" />',
        customClass: {
            container: 'swal-error',
        },
        ...defaultOptions,
        ...options,
    };
    Swal.fire(basic);
};

export const SwalSuccess = (options: SweetAlertOptions = {}) => {
    const basic: SweetAlertOptions = {
        iconHtml: '<i class="tio-checkmark_circle_outlined" />',
        customClass: {
            container: 'swal-success',
        },
        ...defaultOptions,
        ...options,
    };
    Swal.fire(basic);
};

export const SwalWarning = (options: SweetAlertOptions = {}) => {
    const basic: SweetAlertOptions = {
        iconHtml: '<i class="tio-error_outlined" />',
        customClass: {
            container: 'swal-warning',
        },
        ...defaultOptions,
        ...options,
    };
    Swal.fire(basic);
};

export const SwalInfo = (options: SweetAlertOptions = {}) => {
    const basic: SweetAlertOptions = {
        iconHtml: '<i class="tio-error_outlined" />',
        customClass: {
            container: 'swal-info',
        },
        ...defaultOptions,
        ...options,
    };
    Swal.fire(basic);
};
