<?php 

use axiltheme\abstrak_elements\axil_Elements_Helper;

add_action( 'wp_ajax_get_projects', 'get_projects' );
add_action( 'wp_ajax_nopriv_get_projects', 'get_projects' );

function get_projects() {
    parse_str($_REQUEST['formData'], $formData);
    $col_gap = $formData['col_gap'];
    $col_class = $formData['col_class'];
    $project_content_disable = $formData['project_content_disable'];
    $project_link_img_disable = $formData['project_link_img_disable'];
    $project_img_popup_disable = $formData['project_img_popup_disable'];
    $project_title_link_disable = $formData['project_title_link_disable'];

    $settings = [];    
    $category_list = !empty($_REQUEST['category']) ? explode(" ", $_REQUEST['category']) : '';
    $settings['category'] = $category_list;
    $exclude_posts = implode(", ", $formData['post__not_in']);
    $settings['post__not_in'] = $exclude_posts;
    $settings['posts_per_page'] = $formData['posts_per_page'];
    $settings['offset'] = $formData['offset'];
    $settings['orderby'] = $formData['orderby'];
    $settings['order'] = $formData['order'];

    $query_args = axil_Elements_Helper::axil_get_query_args('axil-projects', 'axil-projects-category', $settings);

    $query = new \WP_Query($query_args);
    $i = 1;
    if ($query->have_posts()) { ?>
        <div class="row <?php echo esc_attr($col_gap); ?> project-list">
            <?php while ($query->have_posts()) {
                global $post;
                $query->the_post();
                $terms = get_the_terms($post->ID, 'axil-projects-category');
                if ($terms && !is_wp_error($terms)) {
                    $termsList = array();
                    foreach ($terms as $category) {
                        $termsList[] = $category->slug;
                    }
                    $termsAssignedCat = join(" ", $termsList);
                } else {
                    $termsAssignedCat = '';
                }
                $active = ($i == 1) ? 'active' : '';
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
                ?>
                <!-- Start Single Portfolio -->
                <div class="<?php echo esc_attr($col_class); ?> <?php echo esc_attr($active); ?> <?php echo esc_attr($termsAssignedCat); ?>">
                    <div class="project-grid">
                        <div class="thumbnail <?php echo esc_attr($project_content_disable); ?>"> 
                            <?php if ( $project_link_img_disable == 'yes' ) { ?> 
                                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('axil-project-thumb'); ?></a>
                            <?php } else {  ?>    
                                <?php if ( $project_img_popup_disable == 'yes' ) { ?>  
                                    <a href="<?php echo esc_url($featured_img_url); ?>"><?php the_post_thumbnail('axil-project-thumb'); ?></a>  
                                <?php } else {  ?>  
                                    <?php the_post_thumbnail('axil-project-thumb'); ?>
                                <?php } ?>               
                            <?php } ?>

                        </div>  
                        <?php if ( $project_content_disable == 'project_content_disable_no' ) { ?>  
                            
                            <div class="content">
                                <?php if ( $project_title_link_disable == 'yes' ) { ?> 
                                    <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> </h4>   
                                <?php  }else{ ?>   
                                    <h4 class="title"><?php the_title(); ?></h4>        
                                <?php  } ?>
                            <?php if ($terms && !is_wp_error($terms)): ?>
                                <span class="subtitle">                                       
                                    <span><?php echo axil_Elements_Helper::axil_get_projects_cat( get_the_id()); ?></span>
                                </span>
                            <?php endif ?>
                            </div>
                        <?php  } ?> 

                    </div>
                </div>
                <!-- End Single Portfolio -->
                <?php $i++;
            } ?>
            <?php wp_reset_postdata(); ?>
        </div>
    <?php }
    die();
}